* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Basic cleaning

sort gvkey fyear 

* Delete non-US firms
drop if fic ~= "USA"
drop if fyear > 2018

* Drop certain sectors
destring sic, replace
drop if sic >= 6000 & sic <= 6999 /* Finance */
drop if sic >= 4900 & sic <= 4949 /* Utilities */
drop if sic >= 9000 & sic <= 9999 /* Government */

* Create two-digit NAICS
gen NAICS = substr(naics,1,2) 
lab var NAICS "Two-Digit NAICS"
destring NAICS, replace

* Age in CS must be at least 2
bys gvkey: egen year1 = min(fyear)
bys gvkey: egen year2 = max(fyear)
gen Compustatage = fyear - year1
drop if Compustatage<2

* Data cleaning
drop if sale<0.1 | at<0.1 | at==. | emp<0.1 | ppegt<0.1 | dp==. | dpact==. | dp==0 | dpact==0 
drop if emp==. | oibdp==.
drop if sale==. | ppegt==. 
drop if  capx==. | capx<=0 

* Merge wages, GDP deflator (for output) and investment deflator (for investment, capital)
merge m:1 fyear using "$datapath/prices_updated.dta", keep(match) 
drop _merge
replace wage=wage/1000 
sort gvkey fyear

egen id = group(gvkey)
lab var id "Firm id"

replace aqc = . if aqc < 0 
replace sppe = . if sppe < 0
